function a =tensor_a_nonlin(u, x, y)
%TENSOR_A   Evaluate conductivity tensor A
%   A = TENSOR_A(X,Y) returns function values at a discrete point given by
%   X on the macro and Y on the micro domain (see article for details).
%   This input data has to be chosen by the user. 
%   X has dimension 1 x 2 and Y has dimension 1 x 2. A is a 2 x 2 matrix.
%
%   See also HMMFEM2D, F, and G.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

aa=(1+u^2)*1/10*64/(9*sqrt(17))*(sin(2*pi*y(:,1))+9/8) .* (cos(2*pi*y(:,2))+9/8);
a= [aa, zeros(size(y,1),1); ...
  zeros(size(y,1),1), aa];

end