function copyright_fehmm_nonlin


% FE-HMM-NONLIN is a MATLAB program designed to solve the nonlinear equation
%      - div(a(u)*grad(u)) = f in Omega
%                     u = u_D on the Dirichlet boundary
%                d/dn u = g   on the Neumann boundary
% with a highly oscillatory tensor a(x,u) depending nonlinearly of u.
%
%   The code is available at http://iacs.epfl.ch/anmc/ and described in 
%   further detail in 
%
%   A. Abdulle and G. Vilmart
%   "Fully discrete analysis of the finite element heterogeneous multiscale method 
%   for nonmonotone elliptic homogenization problems", 
%   submitted for publication. 32 pages.
%   Preprint available at: http://infoscience.epfl.ch/record/163326/
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%   This code is a nonlinear extension of the linear code
%   FE_HMM2D, Copyright (C) 2009 A. Abdulle and A. Nonnenmacher described in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   Vol. 198 (2009) p. 2839-2859.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   If you are interested in commercial use, please contact the authors.
%
%
%
% This program is free software; you can redistribute it and/or 
% modify it under the terms of the GNU General Public License as 
% published by the Free Software Foundation; either version 2 of 
% the License, or (at your option) any later version. 
%
% This program is distributed in the hope that it will be useful, 
% but WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
% General Public License for more details. 
% 
% You should have received a copy of the GNU General Public License 
% along with this program; if not, write to the Free Software 
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
% USA. 

