function [A_macroL]=hmm_microstima_nonlin(Uquadnode,...
    quadnode, refquadnode, MicroElements, MicroCoordinates, Map,...
    MacroVertices, Constraints, epsilon, delta, bctype,Nnode)
% HMM_MICROSTIMA_NONLIN   Computes element stiffness matrix for micro 
% parallelograms in the case of nonlinear tensors. 
% This is an extension of function HMM_MICROSTIMA_TRI and HMM_MICROSTIMA_QUAD 
% to the case of nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialization
NoOfNodes = size(MicroCoordinates,1);

%Stiffness matrix Assembly
% For meshes with many DOF this can be very slow due to Matlab's way of 
% handling sparse matrices. 

 A = sparse(NoOfNodes,NoOfNodes);
 for j=1:size(MicroElements,1)
     A(MicroElements(j,:), MicroElements(j,:)) = ...
       A(MicroElements(j,:), MicroElements(j,:)) + ...
       hmm_microstima_quad_nonlin(MicroCoordinates(MicroElements(j,:),:),...
       Uquadnode, quadnode, epsilon);
 end

% Get constraint matrix and corresponding rhs for the lagrange multiplier
% micro boundary conditions.    
switch(lower(bctype))
    case{'dirichlet'}
        [ConstraintMat, ConstraintRhs]=...
            micro_constraints_dirichlet(Constraints, Map, MacroVertices ,...
            MicroElements, MicroCoordinates, refquadnode);
    case{'periodic'}
        [ConstraintMat, ConstraintRhs]=...
            micro_constraints_periodic(Constraints, Map, MacroVertices ,...
            MicroElements, MicroCoordinates, refquadnode);
end

% Assemble matrix AConstr for constrained system and corresponding rhs
AConstr=[A ConstraintMat';...
    ConstraintMat sparse(size(ConstraintMat,1),size(ConstraintMat,1))];
%RhsConstr=[zeros(NoOfNodes,4);ConstraintRhs];
RhsConstr=[zeros(NoOfNodes,Nnode);ConstraintRhs];

% solve constrained microproblem
x=AConstr\RhsConstr;
alpha=x(1:size(MicroCoordinates,1),:);

% area of macro-element and micro-domain
K_macro=det([1,1,1; MacroVertices(1:3,:)']);
K_micro=delta^2;
    
A_macroL=K_macro/K_micro *alpha'*A*alpha;
    
end



