function M = hmm_microstima_quad_nonlin(vertices,...
    UMacro,MacroQuadNode, epsilon)
%HMM_MICROSTIMA_QUAD_NONLIN   Computes element stiffness matrix for micro parallelograms.
% This is an extension of function HMM_MICROSTIMA_QUAD to the case of
% nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% map from reference element
Map=[vertices(2,:)-vertices(1,:);vertices(4,:)-vertices(1,:)]';

% gauss quadrature at the 4 quadrature nodes, reference element and mapped
% element
quadnodes_ref=[.5-sqrt(3)/6, .5+sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6;...
               .5-sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6, .5+sqrt(3)/6];
quadnodes= Map*quadnodes_ref+repmat(vertices(1,:)',1,4);


M=zeros(4,4);
for node=1:4
    quadnode=quadnodes(:,node)';
    x=quadnodes_ref(1,node);
    y=quadnodes_ref(2,node);
    
    phi_prime_hat=[y-1, x-1; 1-y, -x; y, x; -y, 1-x];
    phi_prime_invD=(phi_prime_hat/Map); 
    
    % evaluate coefficiency tensor at the specific nodes
    a=tensor_a_nonlin(UMacro, MacroQuadNode, quadnode/epsilon);
    
    M=M+phi_prime_invD*a*phi_prime_invD';
end
M=(det(Map))*M/4;

end