function A_macro=hmm_stima_quad_nonlin(UMacro, NMicro,...
     epsilon,MicroElements,MacroVertices, Constraints, delta, bctype)
%HMM_STIMA_QUAD_NONLIN   Computes element stiffness matrix for micro parallelograms.
% This is an extension of function HMM_MICROSTIMA_QUAD to the case of
% nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% initialization of variables
A_macro=zeros(4,4);
B_macro=zeros(4,4);

% transformation matrix for affine map to reference element
Map=[MacroVertices(2,:)-MacroVertices(1,:);MacroVertices(4,:)-MacroVertices(1,:)]';
% reference and physical quadrilateral quadrature nodes
quadnodes_ref=[.5-sqrt(3)/6, .5+sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6;...
               .5-sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6, .5+sqrt(3)/6];
quadnodes= Map*quadnodes_ref+repmat(MacroVertices(1,:)',1,4);

Mbasis=[1/3+sqrt(3)/6,1/6,1/3-sqrt(3)/6,1/6;...
   1/6,1/3+sqrt(3)/6,1/6,1/3-sqrt(3)/6;...
   1/6,1/3-sqrt(3)/6,1/6,1/3+sqrt(3)/6;...
   1/3-sqrt(3)/6,1/6,1/3+sqrt(3)/6,1/6];

Nnode=4;

for node_no=1:4
    % select current quadrature nodes
    quadnode=quadnodes(:,node_no);
    refquadnode=quadnodes_ref(:,node_no);
    Uquadnode=Mbasis(node_no,:)*UMacro;

    % Generate micro-coordinates
    [MicroCoordinates]=micromesh_coords(NMicro, quadnode, delta);
    
    A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
    quadnode, refquadnode, MicroElements, MicroCoordinates, Map,...
    MacroVertices, Constraints, epsilon, delta, bctype, Nnode);

    A_macro=A_macro+.25 *A_macroL1;
end

end







%
% Appendix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     % stiffness matrix assembly - fast version
%
%     indexx=zeros(4*4*size(MicroElements,1),1);
%     indexy=zeros(4*4*size(MicroElements,1),1);
%     value= zeros(4*4*size(MicroElements,1),1);
% 
%     for j=1:size(MicroElements,1)
%         M=hmm_microstima_quad(MicroCoordinates(MicroElements(j,:),:),...
%              quadnode, epsilon);
% 
%         tmpa=repmat(MicroElements(j,:),1,4);
%         tmpb=repmat(MicroElements(j,:),4,1);
%         tmpM(:,:)=M;
%         indexx(1+(j-1)*16:j*16)=tmpa(:);
%         indexy(1+(j-1)*16:j*16)=tmpb(:);
%         value(1+(j-1)*16:j*16)=tmpM(:);
%     end
%     A=sparse(indexx,indexy,value,...
%         size(MicroCoordinates,1),size(MicroCoordinates,1));
