function [A_macro,B_macro]=hmm_stima_quad_nonlin_jac(UMacro, NMicro,NMicroB,...
     epsilon,MicroElements,MicroElementsB,MacroVertices, Constraints, ...
     ConstraintsB, delta, bctype)
%HMM_STIMA_QUAD_NONLIN_JAC  Computes element stiffness matrix for macro parallelograms.
% This is an extension of function HMM_STIMA_QUAD to the case of nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   A_MACRO = HMM_STIMA_QUAD(VERTICES, MACROQUADNODE, EPSILON) 
%   computes the entry to the macro element stiffness matrix for macro
%   parallelograms using parallelograms on the micro sampling domain and
%   specified boundary conditions on the micro problem.
%
%   B_MACRO = associated jacobian matrix used for the Newton iterations.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% initialization of variables
A_macro=zeros(4,4);
B_macro=zeros(4,4);

% transformation matrix for affine map to reference element
Map=[MacroVertices(2,:)-MacroVertices(1,:);MacroVertices(4,:)-MacroVertices(1,:)]';
% reference and physical quadrilateral quadrature nodes
quadnodes_ref=[.5-sqrt(3)/6, .5+sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6;...
               .5-sqrt(3)/6, .5-sqrt(3)/6, .5+sqrt(3)/6, .5+sqrt(3)/6];
quadnodes= Map*quadnodes_ref+repmat(MacroVertices(1,:)',1,4);

Mbasis=[1/3+sqrt(3)/6,1/6,1/3-sqrt(3)/6,1/6;...
   1/6,1/3+sqrt(3)/6,1/6,1/3-sqrt(3)/6;...
   1/6,1/3-sqrt(3)/6,1/6,1/3+sqrt(3)/6;...
   1/3-sqrt(3)/6,1/6,1/3+sqrt(3)/6,1/6];

Nnode=4;

for node_no=1:4
    % select current quadrature nodes
    quadnode=quadnodes(:,node_no);
    refquadnode=quadnodes_ref(:,node_no);
    
    Uquadnode=Mbasis(node_no,:)*UMacro;

    % Generate micro-coordinates
    [MicroCoordinates]=micromesh_coords(NMicro, quadnode, delta);
    
    A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
    quadnode, refquadnode, MicroElements, MicroCoordinates, Map,...
    MacroVertices, Constraints, epsilon, delta, bctype, Nnode);

    A_macro=A_macro+.25 *A_macroL1;

    % compute derivative
    if (NMicroB==NMicro)
        MicroCoordinatesB=MicroCoordinates;
    else
        [MicroCoordinatesB]=micromesh_coords(NMicroB, quadnode, delta);
        A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
        quadnode, refquadnode, MicroElementsB, MicroCoordinatesB, Map,...
        MacroVertices, ConstraintsB, epsilon, delta, bctype, Nnode);
    end
    A_macroL2=hmm_microstima_nonlin(Uquadnode+sqrt(eps), ...
    quadnode, refquadnode, MicroElementsB, MicroCoordinatesB, Map,...
    MacroVertices, ConstraintsB, epsilon, delta, bctype, Nnode);
    
    B_macro=B_macro+...
        .25 *(A_macroL2-A_macroL1)*UMacro/sqrt(eps)*Mbasis(node_no,:);    
end

end
