function A_macro=hmm_stima_tri_nonlin(UMacro, NMicro, ...
    epsilon, MicroElements, MacroVertices, Constraints, delta, bctype)
%HMM_STIMA_TRI_NONLIN   Computes element stiffness matrix for micro parallelograms.
% This is an extension of function HMM_MICROSTIMA_TRI to the case of
% nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% U an barycenter of triangle
Uquadnode=sum(UMacro)/3;

% generate micro-coordinates
quadnode=sum(MacroVertices(:,:))/3;

Nnode=3;
refquadnode=0;

[MicroCoordinates]=micromesh_coords(NMicro, quadnode, delta);

Map=[MacroVertices(2,:)-MacroVertices(1,:);MacroVertices(3,:)-MacroVertices(1,:)]';

A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
  quadnode, refquadnode, MicroElements, MicroCoordinates, Map,...
  MacroVertices, Constraints, epsilon, delta, bctype,Nnode);

A_macro=0.5*A_macroL1;
