function [A_macro,B_macro]=hmm_stima_tri_nonlin_jac(UMacro, NMicro, NMicroB, ...
    epsilon, MicroElements, MicroElementsB,...
    MacroVertices, Constraints, ConstraintsB, delta, bctype)
%HMM_STIMA_TRI_NONLIN_JAC   Computes element stiffness matrix for macro triangles.
% This is an extension of function HMM_STIMA_TRI to the case of nonlinear tensors. 
%
%   This function should not be modified.
%
%   Email           : assyr.abdulle@epfl.ch and gilles.vilmart@epfl.ch
%   Last updated    : 08/07/2011 with MATLAB 7.9
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   FE_HMM2D_NONLIN is Copyright (C) 2011 A. Abdulle and G. Vilmart. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   A_MACRO = HMM_STIMA_QUAD(VERTICES, MACROQUADNODE, EPSILON) 
%   computes the entry to the macro element stiffness matrix for macro
%   parallelograms using parallelograms on the micro sampling domain and
%   specified boundary conditions on the micro problem.
%
%   B_MACRO = associated jacobian matrix used for the Newton iterations.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% U an barycenter of triangle
Uquadnode=sum(UMacro)/3;

% generate micro-coordinates
quadnode=sum(MacroVertices(:,:))/3;

Nnode=3;
refquadnode=0;

[MicroCoordinates]=micromesh_coords(NMicro, quadnode, delta);

Map=[MacroVertices(2,:)-MacroVertices(1,:);MacroVertices(3,:)-MacroVertices(1,:)]';

A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
  quadnode, refquadnode, MicroElements, MicroCoordinates, Map,...
  MacroVertices, Constraints, epsilon, delta, bctype,Nnode);

A_macro=0.5*A_macroL1;

% compute derivative
if (NMicroB==NMicro)
    MicroCoordinatesB=MicroCoordinates;
else
    [MicroCoordinatesB]=micromesh_coords(NMicroB, quadnode, delta);
    A_macroL1=hmm_microstima_nonlin(Uquadnode, ...
    quadnode, refquadnode, MicroElementsB, MicroCoordinatesB, Map,...
    MacroVertices, ConstraintsB, epsilon, delta, bctype,Nnode);
end
    
A_macroL2=hmm_microstima_nonlin(Uquadnode+sqrt(eps), ...
  quadnode, refquadnode, MicroElementsB, MicroCoordinatesB, Map,...
  MacroVertices, ConstraintsB, epsilon, delta, bctype,Nnode);
    

B_macro=repmat(0.5*(A_macroL2-A_macroL1)*UMacro/sqrt(eps)/3,1,3);



% %%%%%%%%%%%%%%%%
% 
% ubary=Uquadnode;
% bary=quadnode;
% 
% 
% % initialization of variables
% NoOfNodes = size(MicroCoordinates,1);
% A = sparse(NoOfNodes,NoOfNodes);
% 
% % stiffness matrix assembly
% % For meshes with many DOF this can be very slow due to Matlab's way of 
% % handling sparse matrices. An optimized code can be found at the very
% % bottom of this file.
% for j=1:size(MicroElements,1)
%     A(MicroElements(j,:), MicroElements(j,:)) = ...
%         A(MicroElements(j,:), MicroElements(j,:)) + ...
%         hmm_microstima_quad_nonlin(MicroCoordinates(MicroElements(j,:),:),...
%             ubary+sqrt(eps),bary, epsilon);
% end
%         
% 
% % solution of cell problems dilatation for the macro element
% D=[MacroVertices(2,:)-MacroVertices(1,:);MacroVertices(3,:)-MacroVertices(1,:)]';
% 
% % get constraint matrix and corresponding rhs for the lagrange multiplier
% 
% switch(lower(bctype))
%     case{'dirichlet'}
%         [ConstraintMat, ConstraintRhs]=...
%             micro_constraints_dirichlet(Constraints, D, MacroVertices ,...
%             MicroElements, MicroCoordinates, 0);
%     case{'periodic'}
%         [ConstraintMat, ConstraintRhs]=...
%             micro_constraints_periodic(Constraints, D, MacroVertices ,...
%             MicroElements, MicroCoordinates, 0);
% end
% 
% % assemble matrix for constraint system and corresponding rhs
% AConstr=[A ConstraintMat';...
%     ConstraintMat sparse(size(ConstraintMat,1),size(ConstraintMat,1))];
% RhsConstr=[zeros(NoOfNodes,3);ConstraintRhs];
% 
% % finally solve
% x=AConstr\RhsConstr;
% alpha=x(1:size(MicroCoordinates,1),:);
% 
% % area of macro-element and micro-domain
% K_macro=.5*det([1,1,1; MacroVertices']);
% K_micro=delta^2;
% 
% % the entries for the macro stiffness matrix
% A_macro=K_macro/K_micro *alpha'*A*alpha
% pause
% 
% end




%
% Appendix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % stiffness matrix assembly - fast version
% indexx=zeros(4*4*size(MicroElements,1),1);
% indexy=zeros(4*4*size(MicroElements,1),1);
% value= zeros(4*4*size(MicroElements,1),1);
% 
% for j=1:size(MicroElements,1)
%     M=hmm_microstima_quad(MicroCoordinates(MicroElements(j,:),:),...
%             bary, epsilon);
% 
%     tmpa=repmat(MicroElements(j,:),1,4);
%     tmpb=repmat(MicroElements(j,:),4,1);
%     tmpM(:,:)=M;
%     indexx(1+(j-1)*16:j*16)=tmpa(:);
%     indexy(1+(j-1)*16:j*16)=tmpb(:);
%     value(1+(j-1)*16:j*16)=tmpM(:);
% end
% A=sparse(indexx,indexy,value,...
%             size(MicroCoordinates,1),size(MicroCoordinates,1));
