function [MicroCoordinates]=micromesh_coords(NMicro, center, delta)
%MICROMESH_COORDS   Computes node coordinates for a micro sampling domain
%   MICROCOORDINATES = MICROMESH_COORDS(NMICRO, CENTER, DELTA)
%   Computes the coordinates of the nodes for the micro sampling domain 
%   meshed using rectangles.
%    
%   NMICRO  is the number of degrees of freedom per space dimension in the
%   micro domain
%
%   CENTER contains the coordinates of the center of the sampling domain.
%   These usually are the barycenters for macro triangles or the quadrature nodes 
%   for macro parallelograms.
%
%   DELTA is the width or height of the square sampling domain.
%
%
%   This function should not be modified.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% divide each dimension into N equidistant nodes
x=linspace(center(1)-.5*delta, center(1)+.5*delta, NMicro);
y=linspace(center(2)-.5*delta, center(2)+.5*delta, NMicro);

% build 2d-grid
[xx,yy] = meshgrid(x,y);
% and reshape so we get one matrix with the coordinates
MicroCoordinates = [xx(:) yy(:)];

end
