function [MicroElements]=micromesh_elements(N)
%MICROMESH_ELEMENTS   Computes the micro sampling domain triangulation
%   MICROELEMENTS = MICROMESH_ELEMENTS(NMicro)
%   Computes the triangulation of the micro sampling domain using
%   square micro elements and returns the node numbers of the
%   triangulation.
%    
%   N=NMICRO  is the number of degrees of freedom per space dimension in the
%   micro domain
%
%   MICROELEMENTS has dimension (NMicro-1)^2 x 4 and contain the node
%   numbers of the triangulation of the micro sampling domain.
%
%
%   This function should not be modified.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


MicroElements=zeros( (N-1)*(N-1), 4);
for j=0:N-2
    MicroElements(1+j*(N-1):N-1+j*(N-1),:)=...
        [(1+j*N:N-1+j*N)', (N+1+j*N:N+N-1+j*N)',...
        (N+2+j*N:N+N+j*N)', (2+j*N:N+j*N)'];
end

end