function phi=shapefunction_quad_lin(z,quadnode)
%SHAPEFUNCTION_QUAD   Evaluates the linearized basis function on the reference square
%   PHI = SHAPEFUNCTION_QUAD(Z, QUADNODE)
%   Evaluates the linearized basis function phi(x) on the reference (macro)
%   square, where the linearization is based on the point quadnode.
%
%   Z is a 2 x 1 vector containing the x and y coordinates in the reference
%   square.
%    
%   QUADNODE is a 2 x 1 vector containing the x and y coordinates of the 
%   quadrature node the linearization is based on in the reference square.
%
%   PHI contains the evaluated function value.
%
%
%   This function should not be modified.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% quadrature node, repeated
quadnode_rep=repmat(quadnode', size(z,1), 1);
x=quadnode_rep(:,1); y=quadnode_rep(:,2);

% quadrature node, single
xq=quadnode(1); yq=quadnode(2);

% dx, dy for all the points
dz=z-quadnode_rep;

phi(:,1)= (1-x).*(1-y)+ dz(:,1) *(yq-1) + dz(:,2)* (xq-1);
phi(:,2)=   x.*(1-y)  + dz(:,1) *(1-yq) + dz(:,2)* ( -xq);
phi(:,3)=   x.*y      + dz(:,1) *(  yq) + dz(:,2)* (  xq);
phi(:,4)= (1-x).*y    + dz(:,1) *( -yq) + dz(:,2)* (1-xq);

end