function phi=shapefunction_tri(z)
%SHAPEFUNCTION_TRI   Evaluates the basis function on the reference triangle
%   PHI = SHAPEFUNCTION_TRI(Z)
%   Evaluates the basis function phi(x) on the reference (macro) triangle.
%    
%   Z is a 2 x 1 vector containing the x and y coordinates in the reference
%   triangle.
%
%   PHI contains the evaluated function value.
%
%
%   This function should not be modified.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% x and y coordinates
x=z(:,1); y=z(:,2);

phi(:,1)=1-x-y;
phi(:,2)=x;
phi(:,3)=y;

end