function show_parabolic(Elements3,Elements4,Coordinates,U,N)
%SHOW_PARABOLIC   Plots the solution on a domain consisting of triangles and parallelograms
%   SHOW_PARABOLIC(ELEMENTS3, ELEMENTS4, COORDINATES, U)
%   Plots the solution U on the triangulation descibed by ELEMENTS3,
%   ELEMENTS4 and COORDINATES using a two dimensional spline interpolation.
%
%   ELEMENTS3 denotes a set of triangles with dimension (no. of triangles) x 3.
%
%   ELEMENTS4 denotes a set of parallelograms (dimension (no. of parallelograms) x 4.
%
%   COORDINATES is a (no. of coordinates) x 2 matrix which contains the
%   coordiantes of the nodes of ELEMENTS3 and ELEMENTS4.
%
%   U is a matrix of size Nx(no. of coordinates) which contains the function
%   value at the nodes i.
%
%   N is the number of time steps solutions are stored for.
%
%
%   This function should not be modified.
%
%
%   The code is available at http://anmc.epfl.ch/ and described in 
%   further detail in 
%
%   A. Abdulle and A. Nonnenmacher
%   "A short and versatile finite element multiscale code for
%   homogenization problems"
%   Computer Methods in Applied Mechanics and Engineering,
%   http://dx.doi.org/10.1016/j.cma.2009.03.019
%
%   Please cite this article in any publication describing research
%   performed using the software.
%
%
%   Email           : assyr.abdulle@epfl.ch and achim.nonnenmacher@epfl.ch
%   Last updated    : 04/29/2009 with MATLAB 7.4
%
%   FE_HMM2D is Copyright (C) 2009 A. Abdulle and A. Nonnenmacher. 
%   The software is provided free for non-commercial use unter the terms of 
%   the GNU General Public License. See "copyright.m" for full details.   

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% graphic representation
u0max=max(U(:,1));
u0min=min(U(:,1));
subplot(2,2,1);
show(Elements3,Elements4,Coordinates,full(U(:,1)));
title('u(0)'); zlim([u0min,u0max]);caxis([u0min,u0max]);

subplot(2,2,2);
show(Elements3,Elements4,Coordinates,full(U(:,4)));
title('u(0.3)'); zlim([u0min,u0max]);caxis([u0min,u0max]);

subplot(2,2,3);
show(Elements3,Elements4,Coordinates,full(U(:,8)));
title('u(0.7)'); zlim([u0min,u0max]);caxis([u0min,u0max]);

subplot(2,2,4);
show(Elements3,Elements4,Coordinates,full(U(:,11)));
title('u(1)');  zlim([u0min,u0max]);caxis([u0min,u0max]);

end