c * * * * * * * * * * * * * * * * * * * * * * * * *
c    Driver for SK-ROCK
c    (Use plotconv.m to plot in Matlab the convergence curve
c    using the average over nexp=1e6 trajectories)
c * * * * * * * * * * * * * * * * * * * * * * * * *
c
c    This driver shows how to use SK-ROCK. 
c    It solves the stiff scalar of SDE
c    dX(t) = (-X^3+X)dt+sqrt(2)*dw
c    and compute the error for E(X(T)^2) at time T=10.
c     
c--------------------------------------------------------
      include 'skrock.f' 
			   include 'zufall.f'
			
      implicit double precision (a-h,o-z)
c --- parameters for the problem -----
c LTS parameters
      parameter (neqn=1,nsto=1)
c random generator parameters
      CHARACTER(len=32) :: arg
			CHARACTER*60 NAME
			CHARACTER*4 xstring
c number of samples
			parameter (nexp=10**8)
			parameter (numexp=18)
      double precision TABH(numexp),TABERR(numexp)
c
			double precision winc(nsto)
c--------------------------------------------------------
c      Work is of length 6*neqn
c-------------------------------------------------------- 
c ----- to integrate with srock2.f -----
      dimension y(neqn),work(6*neqn)
      integer iwork(15),idid
      external fheat,gnoise,genrnd

c --- common parameters for the problem -----
      common/deltax/deltax,amu,alambda,ibug
c -------- dimensions and initialisations --------       
      amu=sqrt(2.d0)
	  alambda=1.d0
c initialize random number generator	
			IF (IARGC().GE.1) THEN
			CALL getarg(1, arg)
      Read( arg, '(i10)' )  iseed
			ELSE
			iseed=0
			END IF
      call zufalli(iseed)
c--------------------------------------------------------
c     Initialise iwork: 
c      iwork(1)=1  function RHO returns an upper bound for the spectral radius
c      iwork(2)=1  Case of a diagonal noise (! not implemented)
c      iwork(3)=1  Case of the postprocessed order 2 method for Langevin equation
c      iwork(4)=0  Force polynomial degree if nonzero (automatic otherwise)
c--------------------------------------------------------
      iwork(1)=1
      iwork(2)=0
      iwork(3)=1
      iwork(4)=0		  
			
c ----- end point of integration -----
      tend=10.d0
			nloop=numexp/2
      do iloop=1,2*nloop
c ----- initial step size -----
			   NSTEPS=floor(15.d0*sqrt(2.d0)**(iloop/4.d0))
c      NSTEPS=2**iloop
c			if (iloop.eq.0) NSTEPS=1
c			if (iloop.eq.2*nloop+1) NSTEPS=32
		    h=tend/NSTEPS
			TABH(iloop)=h
			t_old=0.0d0
c ----- integration -----
      write(6,*) 'Integration of the SDE problem' 
c			write (6,*) 'mdeg:',iwork(4)
			write (6,*) 'nsteps:',nsteps
			write (6,*) 'number of samples',nexp
			write (6,*) 'dimensions:',neqn,nsto
			call cpu_time(time0)
c --------- initial values -------
			t=0.d0
			avg2=0.d0
			stddev=0.d0
      do iexp=1,nexp
			if (mod(iexp,nexp/10**1).eq.0) 
     &     write (6,*) 'iexp',(iexp*1.d2)/nexp,
     &            '% ',avg2/iexp,iloop
c initial condition
      y(1)=0.d0
c
      call skrock(neqn,nsto,t,nsteps,h,winc,y,fheat,gnoise,
     &           genrnd,work,iwork,idid) 
c problem scalar
			if (iexp.eq.1) avg2ex=1.0417972964871559519d0
c  The value of avg2ex is computed using Maple  
      uu=y(1)**2
			err=uu-avg2ex
      avg2=avg2+err
      stddev=stddev+err**2
			end do
			avg2=avg2/nexp
			stddev=stddev/nexp
			call cpu_time(time1)
			write (6,*) 'CPU TIME',time1-time0

      TABERR(iloop)=avg2
c ----- print statistics -----    
      write(6,*) 'Max number of stages used=',iwork(10)
      write(6,*) 'Number of f evaluations=',iwork(5),' steps=',iwork(6)
			write(6,*) 'f evaluations for eigmax estimation=',IWORK(9)
      write(6,*) 'winc', winc(1)
		  end do
c save errors in an output file
      Write( xstring, '(i4)' )  iseed
			NAME='resavg'//xstring//'.dat'
			if (iseed.eq.0) NAME='dataavg.dat'
			write(6,*) 'SAVING IN FILE ',NAME
      OPEN(9,FILE=NAME)
      REWIND(9)
			Write (9,*) (TABH(iloop),iloop=1,numexp),
     &   (TABERR(iloop),iloop=1,numexp)
			
c--------------------------------------------------------
c     End of main program
c--------------------------------------------------------
      end      
c--------------------------------------------------------
c     The subroutine RHO gives an estimation of the spectral 
c     radius of the Jacobian matrix of the problem. This
c     is a bound for the whole interval and thus RHO is called
c     once.
c--------------------------------------------------------
      double precision function rho(neqn,t,y)
      implicit double precision (a-h,o-z)
	  dimension y(neqn)
      common/deltax/deltax,amu,alambda,ibug
			rho=abs(3.0d0*y(1)**2-1)
      return
      end
c--------------------------------------------------------
c     The subroutine FHEAT compute the value of f(x,y) and
c     has to be declared as external.
c--------------------------------------------------------
      subroutine fheat(neqn,x,y,f)
      implicit double precision (a-h,o-z)
      dimension y(neqn),f(neqn)
      common/deltax/deltax,amu,alambda,ibug
			   f(1)=-y(1)**3+y(1)
      return
      end
c--------------------------------------------------------
c     The subroutine GNOISE compute the value of g(x,y) and
c     has to be declared as external.
c--------------------------------------------------------
      subroutine GNOISE(neqn,nsto,isto,x,y,g)
      implicit double precision (a-h,o-z)
      dimension y(neqn),g(neqn)
      common/deltax/deltax,amu,alambda,ibug
			
c ---------- discretisation of diffusion -------
c ------ periodic boundary conditions -------
              g(1)=amu
       return  
      end
c --------------------------------------------------------
c  ---- generate random numbers needed at each time step
c ----- uses the code zufall by W. P. Petersen (ETH Zurich)
c --------------------------------------------------------
      subroutine GENRND(NSTO,WINC)
			implicit double precision (a-h,o-z)
      double precision winc(nsto)
c Gaussian random variables
c      call normalen(nsto,winc)
c Discrete Gaussian path
        call zufall(nsto,winc)
				tmp=sqrt(3.d0)
				DO I=1,nsto
				IF (6.0D0*winc(I).LT.1.0D0) THEN
			  Winc(I)=-tmp
			  ELSE IF (6.0D0*winc(I).LE.2.0D0) THEN
			  Winc(I)=tmp
			  ELSE
			  Winc(I)=0.0D0
			  END IF
				END DO
			 return
			 end
c
c c function arcsinh(x)
c c      function csch(x)
c			implicit double precision (a-h,o-z)
c			csch=x
c			do i=1,50
c			delta=(x-sinh(csch))/cosh(csch)
c			csch=csch+delta
c			if (abs(delta).lt.1.d-15) return
c			end do
c			return 
c			end