c * * * * * * * * * * * * * * * * * * * * * * * * *
c    Driver for S-SDIRK
c * * * * * * * * * * * * * * * * * * * * * * * * *
c
c    This driver shows how to use S-SDIRK. 
c    It solves the stiff system of SDEs
c    dX = (Y-1.) + 500.* X(1-X) dt - sqrt(500)* X(1-X) dW
c    dY = 4.* X(1-X) dt - 1.* X(1-X) dW
c    and compute the second moment error for X(T) at time T=1.
c     
c--------------------------------------------------------
c ----- to integrate with rock2.f ----- 
      include 'ssdirk.f' 
      include 'decsol.f' 
			include 'zufall.f'
			
      implicit double precision (a-h,o-z)
c --- parameters for the problem -----
c dimensions of the SDE problem
      parameter (neqn=2,nsto=1)
c to save results in a file
			CHARACTER*60 NAME
			parameter (nexp=10**4)
			parameter (numexp=6)
c for the random number generator
			double precision svblk(608)
c-------------------------------------------------------- 
c ----- to integrate with ssdirk.f -----
      dimension y(neqn),winc(2*nsto),
     &   work(12*neqn+nsto*neqn),fjac(neqn,neqn)
      integer iwork(12),ijac(neqn),idid
      external fdrift,gnoise,genrnd

c --- common parameters for the problem -----
			common/pbpop/alpha,alambda1,alambda2,amu1,amu2
c ----- file for solution -----
c -------- dimensions and initialisations --------       
        amu=1.0d0
c initialize random number generator	
			iseed=0
      call zufalli(iseed)
c--------------------------------------------------------
c     Initialise iwork: 
c      iwork(1)=1  Choice of S-SDIRK method
c                  (0=Milstein-Talay, 1=S-SDIRK(2,2), 2=S-SDIRK(3,2) )
c      iwork(2)=1  Convergence until machine precision
c--------------------------------------------------------
      iwork(1)=1
      iwork(2)=1
			tol=1.e-13

c problem parameters
			alpha=1.d0
			alambda1=-500.d0
c			amu1=1.
			amu1=sqrt(-alambda1)
			alambda2=-4.d0
			amu2=1.d0
c time interval size
      tend=1.d0
			
			write (6,*) 'choice of method:',iwork(1)
c
      NAME='dataavg.dat'
			write(6,*) 'SAVING SECOND MOMENT ERRORS OF Y(1) IN FILE ',NAME
      OPEN(9,FILE=NAME)
			REWIND(9)
c
			avg2ex=0.d0
      do iloop=0,numexp
c ----- initial step size -----
      NSTEPS=2**(iloop-1)
			if (iloop.eq.0) then
c Number of steps for the reference solution
			NSTEPS=1000
			write (6,*) 'number of samples',nexp
			write (6,*) 'SDE dimensions:',neqn,nsto
			end if
c ----- integration -----
      h=tend/NSTEPS
			call cpu_time(time0)
c --------- initial values -------
			
			avg2=0.d0
      do iexp=1,nexp
c ----- to integrate with ssdirk.f ----- 
c initial condition
      y(1)=0.95d0
      y(2)=0.95d0
			t=0.d0
      call ssdirk(neqn,nsto,t,nsteps,h,winc,y,fdrift,gnoise,genrnd,
     &           fjac,ijac,work,iwork,idid,tol) 
c ---------------------------------------
c compute second moment of y(1)
      avg2=avg2+(y(1)**2-avg2ex)
			end do
			call cpu_time(time1)
			avg2=avg2/nexp
			if (iloop.eq.0) avg2ex=avg2
c ----- print statistics -----
			write (6,*) 'nsteps',nsteps,'H',H,'cpu time',time1-time0
		  if (nloop.eq.0) write (6,*) 'reference solution',avg2
			if (nloop.gt.0) write (6,*) 'error',avg2
			write (6,*) '-----------'
			write (9,*) H,avg2
		  end do
			
c--------------------------------------------------------
c     End of main program
c--------------------------------------------------------
      end      
c--------------------------------------------------------
c     The subroutine FDRIFT compute the value of f(x,y) and
c     has to be declared as external.
c--------------------------------------------------------
      subroutine fdrift(neqn,x,y,f,fjac,is_jac)
      implicit double precision (a-h,o-z)
      dimension y(neqn),f(neqn),fjac(neqn,neqn)
			logical is_jac
			common/pbpop/alpha,alambda1,alambda2,amu1,amu2
			
			f(1)=alpha*(y(2)-1.d0)-alambda1*y(1)*(1.d0-y(1))
			f(2)=-alambda2*y(2)*(1.d0-y(2))
			
			if (is_jac) then
			fjac(1,1)=2.0d0*alambda1*y(1) - alambda1
			fjac(2,1)=0.d0
			fjac(1,2)=alpha
			fjac(2,2)=2.0d0*alambda2*y(2) - alambda2
			end if
      return
      end
c--------------------------------------------------------
c     The subroutine GNOISE compute the value of g(x,y) and
c     has to be declared as external.
c--------------------------------------------------------
      subroutine GNOISE(neqn,nsto,isto,x,y,g)
      implicit double precision (a-h,o-z)
      dimension y(neqn),g(neqn)
			common/pbpop/alpha,alambda1,alambda2,amu1,amu2
       g(1)=-amu1*y(1)*(1.d0-y(1))
			 g(2)=-amu2*y(2)*(1.d0-y(2))
			 return
      end
c --------------------------------------------------------
c  ---- generate random numbers needed at each time step
c ----- uses the code zufall by W. P. Petersen (ETH Zurich)
c --------------------------------------------------------
      subroutine GENRND(NSTO,WINC)
			implicit double precision (a-h,o-z)
      double precision winc(2*nsto)
c Gaussian random variables
c      call normalen(nsto,winc)
c Discrete Gaussian path
        call zufall(2*nsto,winc)
				tmp=sqrt(3.d0)
				DO I=1,nsto
				IF (6.0D0*winc(I).LT.1.0D0) THEN
			  Winc(I)=-tmp
			  ELSE IF (6.0D0*winc(I).LE.2.0D0) THEN
			  Winc(I)=tmp
			  ELSE
			  Winc(I)=0.0D0
			  END IF
				END DO
c
				DO I=nsto+1,2*nsto
				IF (winc(I).LT.0.5D0) THEN
			  Winc(I)=1.d0
				ELSE
			  Winc(I)=-1.d0
			  END IF
				END DO
			 return
			 end