      subroutine ssdirk(neqn,nsto,t,nsteps,h,winc,y,f,g,genrnd,
     &   fjac,ijac,work,iwork,idid,tol)
c ----------------------------------------------------------
c   
c    Second weak order explicit stabilized methods 
c    for stiff It stochastic differential equations 
c    dX(t) = f(t,X(t)) dt + sum_i g^i(t,X(t)) dW_i(t)
c
c    This algorithm is described in
c    [ ] A. Abdulle, G. Vilmart, and K.C. Zygalakis 
c        Mean-square A-stable diagonally drift-implicit 
c        integrators of weak second order for stiff 
c        It stochastic differential equations
c        to appear in BIT Numerical Mathematics, 2013
c
c    PLEASE CITE THE ABOVE PAPER WHEN USING S-SDIRK:
c    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
c    Version of 3nd February 2013
c      
c     Input parameters  
c     ----------------  
c     NEQN:       Number of differential equations of the system 
c                 (integer).
c
c     NSTO:       Number of standard Wiener processed
c
c     T:          Initial point of integration (double precision).
c
c     NSTEPS:     Number of time steps (positive integrer)
c
c     H:          Constant stepsize
c
c     Y(NEQN):    Initial value of the solution 
c                 (double precision array of length neqn).
c
c     F:          Name (external) of subroutine computing the value 
c                 of f(x,y) and also its Jacobian if is_jac=true. 
c                 Must have the form
c
c                   subroutine f(neqn,t,y,dy,dyjac,is_jac)
c                   double precision y(neqn),dy(neqn),dyjac(neqn,neqn)
c                   integer neqn
c                   logical is_jac
c                   dy(1)=...
c                   ...
c                   dy(neqn)=...
c                   return
c                   end 
c
c     G:          Name (external) of subroutine computing the value 
c                 of g^i(x,y) where i is the noise index. 
c                 Must have the form
c
c                   subroutine g(neqn,nsto,i,t,y,dy)
c                   double precision y(neqn),dy(neqn)
c                   integer neqn
c                   dy(1)=...
c                   ...
c                   dy(neqn)=...
c                   return
c                   end 
c
c     IWORK(*):   Integer array of length 12 that gives information 
c                 on how the problem is to be solved and communicates 
c                 statistics about the integration process.
c               
c     IWORK(1):   =0 Explicit derivative free Milstein-Talay method
c                    for nonstiff SDE problems
c                 =1 S-SDIRK(2,2) : 
c                    Drift-implicit integrator for highly stiff SDEs
c                    (Mean-square L-stable)
c                 =2 S-SDIRK(3,2) : 
c                    Drift-implicit integrator for moderately stiff SDEs
c                    (Mean-square A-stable)
c
c     IWORK(2):   =1 Newton convergence until machine precision
c
c     WORK(*) :     Workspace of length 12*neqn+nsto*neqn
c     FJAC(*) :     Workspace of length neqn*neqn
c     IJAC(*) :     Workspace of length neqn
c                  
c     IDID:         Report on successfulness upon return
c                   (integer).
c
c
c     Output parameters 
c     -----------------
c     T:          T-value for which the solution has been computed
c
c     Y(NEQN):    Numerical solution at tend.
c
c     IDID:       Reports what happened upon return
c
c     IDID        =1 Successful computation
c                    to continue call SSDIRK again without
c                    altering any arguments.
c                 =-1 Invalid input parameters.
c                 =-3 Newton method failed to converge
c
c     IWORK(7):   = Max number of Newton iterations
c-------------------------------------------------------------------
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
c         Numerical method
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***

c *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***          
c             Declarations 
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***
c
      double precision y(neqn),work(*),winc(*),fjac(*),
     & t,h,uround,tol
      integer iwork(12),neqn,i,n1,n2,n3,n4,n5,n6,n7,n8,
     & n9,n10,n11,n12,n13,nsto,idid,imeth,ijac(*),nsteps
      logical arret
      external f,g,genrnd
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
c             Initializations
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
      arret=.false.
c -------- Prepare the entry-points for the arrays in work.--------   
      imeth=iwork(1)
			if (imeth.lt.0.or.imeth.gt.2.or.nsteps.lt.0) then
			idid=-2
			return
			end if
      n1=1
      n2=n1+neqn
      n3=n2+neqn
      n4=n3+neqn
			n5=n4+neqn
			n6=n5+neqn
			n7=n6+neqn
			n8=n7+neqn
			n9=n8+neqn
			n10=n9+neqn
			n11=n10+neqn
			n12=n11+neqn
			n13=n12+neqn
c -------- Call to the core integrator. -----------
      call rockcore(neqn,nsto,t,nsteps,h,winc,y,f,g,work,work(n1),
     & work(n2),work(n3),work(n4),
     & iwork,idid,work(n5),work(n6),
     & work(n7),work(n8),work(n9),work(n10),work(n11),
     & work(n13),fjac,ijac,imeth,tol)
      return
      end
c ----------------------------------------------
c     End of subroutine ROCK2.
c ----------------------------------------------
c
      subroutine rockcore(neqn,nsto,t,nsteps,h,winc,y,f,g,work,
     & yn,fn,yjm1,yjm2,iwork,
     & idid,yks1,yks2,yjm3,yjm4,y2,fnc,yrk0,
     & stomat,fjac,ijac,imeth,tol)
c ----------------------------------------------
c    Core integrator for ROCK2.
c ---------------------------------------------- 
c             Declarations
c ----------------------------------------------
       double precision y(*),yn(*),fn(*),work(*),yjm1(neqn),
     & yjm2(neqn),fjac(*),h,t,
     & yks1(neqn),yks2(neqn),yjm3(neqn),
     & yjm4(neqn),fnc(neqn),y2(neqn),yrk0(neqn),
     & stomat(*),winc(*),tmp,tol
       integer iwork(12),neqn,nsto,i,idid,imeth,ijac(*),nsteps,istep
       external f,g
			 integer j,k
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
c             Initializations
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
      iwork(5)=0
      iwork(6)=0
      iwork(7)=0
      iwork(8)=0
      iwork(9)=0
      iwork(10)=0      
      iwork(11)=0
      iwork(12)=0
c -------- Big loop
      do istep=1,nsteps
				tmp=sqrt(h)
				CALL GENRND(NSTO,WINC)
				DO I=1,2*NSTO
				WINC(I)=WINC(I)*tmp
				END DO
c -------- Initialization of the integration step.--------   
10    do i=1,neqn
       yn(i)=y(i)
      end do
c -------- Computation of an integration step.--------
      call rtstep(neqn,nsto,t,h,y,f,g,yn,fn,yjm1,yjm2,
     & yks1,yks2,yjm3,stomat,winc,fjac,ijac,imeth,tol)
      t=t+h
			end do
			idid=1
      return      
      end
c ----------------------------------------------
c     End of subroutine rockcore.
c ----------------------------------------------  
c           
      subroutine rtstep(neqn,nsto,t,h,y,f,g,yn,fn,yjm1,yjm2,
     &   yks1,yks2,yjm3,stomat,winc,fjac,ijac,imeth,tol)
c ----------------------------------------------
c             Declarations
c-----------------------------------------------
       double precision y(neqn),yn(neqn),fn(neqn),yjm1(neqn),
     & yjm2(neqn),fjac(neqn,neqn),
     & t,h,ci1,ci2,ci3,temp1,temp2,temp3,ato,rto,
     & yks1(neqn),yks2(neqn),yjm3(neqn),
     & stodouble,stomat(nsto,neqn),winc(2*nsto),
     & alpha,ha,rnd,tmp,h2,tol,
     & gamma,gammah,gammah2,gammah3,gammah4,gammah5
       integer neqn,nsto,mdeg,mr,mz,i,j,k,imeth,ijac(neqn)
       external f,g
			 logical is_jac
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** 
c             Initialisations
c *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***
			h2=0.5d0*h
c -------- First stage.--------
      if (imeth.eq.0) then
			call f(neqn,t,yn,fn,fjac,.false.)
      do i=1,neqn
        yjm1(i)=yn(i)+h2*fn(i)
				yjm2(i)=yn(i)+h*fn(i)
				y(i)=yjm1(i)
      end do
			
   		do j=1,nsto
			call g(neqn,nsto,j,t,yn,stomat(j,1))
			end do
      do i=1,neqn
      do j=1,nsto
      yjm2(i)=yjm2(i)+stomat(j,i)*winc(j)
      end do
      end do

			call f(neqn,t+h2,yjm2,fn,fjac,.false.)
			do i=1,neqn
				y(i)=y(i)+h2*fn(i)
      end do
			do i=1,neqn
			yks1(i)=yjm1(i)
			yks2(i)=yn(i)
			end do
			end if
			
			if (imeth.gt.0) then
			if (imeth.eq.1) gamma=1.d0-sqrt(0.5d0)
			if (imeth.eq.2) gamma=0.5d0+sqrt(3.d0)/6.d0
			gammah=gamma*h
			gammah2=h-2.d0*gammah
			gammah3=gammah**2/gammah2
			gammah4=gammah*(2.d0*h-5.d0*gammah)/gammah2
			gammah5=h2-2.d0*gammah
			
			do i=1,neqn
			yjm1(i)=yn(i)
			end do
			
			is_jac=.true.
      call imeuler(neqn,f,t,gammah,yn,yjm1,yks1,
     &   fn,fjac,ijac,is_jac,iwork,idid,tol)
			do i=1,neqn
			y(i)=yn(i)+h2*fn(i)
			yks2(i)=gammah4*fn(i)
			yjm1(i)=yn(i)+gammah2*fn(i)
			yjm2(i)=yjm1(i)+gammah*fn(i)
			yjm3(i)=yn(i)+gammah*fn(i)
			end do
			
			is_jac=.false.
      call imeuler(neqn,f,t,gammah,yjm1,yjm2,yks1,
     &   fn,fjac,ijac,is_jac,iwork,idid,tol)
			do i=1,neqn
			yks2(i)=yks2(i)+gammah3*fn(i)
			yks1(i)=yn(i)+yks2(i)
			end do
			CALL SOL (neqn, neqn, fjac, yks2, ijac)
			do i=1,neqn
			yks2(i)=yjm3(i)+yks2(i)
			end do
			call f(neqn,t+h2,yks2,fn,fjac,.false.)
			do i=1,neqn
			yks1(i)=yks1(i)+gammah5*fn(i)
			end do

c  store diffusion function values
   		do j=1,nsto
			call g(neqn,nsto,j,t,yks2,stomat(j,1))
			end do

      do i=1,neqn
   		do j=1,nsto
      yjm2(i)=yjm2(i)+winc(j)*stomat(j,i)
      end do
      end do
      call f(neqn,t,yjm2,fn,fjac,.false.)
			do i=1,neqn
			y(i)=y(i)+h2*fn(i)
      end do
			end if
c
      do k=1,nsto
			do i=1,neqn
			yjm1(i)=yks2(i)
			yjm2(i)=yks2(i)
			do l=1,nsto
      if (l.lt.k) tmp=winc(nsto+l)*abs(winc(nsto+l))
			if (l.eq.k) tmp=h
			if (l.gt.k) tmp=-winc(nsto+k)*abs(winc(nsto+k))
			stodouble=0.5d0*(winc(l)*winc(k)-tmp)
c
			tmp=stomat(l,i)*stodouble
			yjm1(i)=yjm1(i)+tmp
			yjm2(i)=yjm2(i)-tmp
			end do
			end do
			call g(neqn,nsto,k,beta2,yjm1,yjm3)
			do i=1,neqn
			y(i)=y(i)+yjm3(i)*0.5d0
			end do
			call g(neqn,nsto,k,beta2,yjm2,yjm3)
			do i=1,neqn
			y(i)=y(i)-yjm3(i)*0.5d0
			end do
			end do
			
			tmp=sqrt(0.5d0)
			do i=1,neqn
			yjm1(i)=0.d0
			do j=1,nsto
			yjm1(i)=yjm1(i)+tmp*stomat(j,i)*winc(nsto+j)
			end do
			end do
c
			do i=1,neqn
			yjm2(i)=yks1(i)+yjm1(i)
			yjm3(i)=yks1(i)-yjm1(i)
			end do		
			do j=1,nsto
			call g(neqn,nsto,j,beta2,yjm2,yks1)
			do i=1,neqn
			y(i)=y(i)+yks1(i)*winc(j)*0.5d0
			end do
			call g(neqn,nsto,j,beta2,yjm3,yks1)
			do i=1,neqn
			y(i)=y(i)+yks1(i)*winc(j)*0.5d0
			end do
			end do
      return 
      end
c ----------------------------------------------
c     End of subroutine rtstep.
c ---------------------------------------------- 
      subroutine imeuler(neqn,f,t,h,y0,y1,ytmp,fnc,
     &   fjac,ijac,is_fjac,iwork,idid,tol)
c-----------------------------------------------
c             Declarations
c-----------------------------------------------
       double precision err,err2,t,h,tol,
     & y0(neqn),y1(neqn),fnc(neqn),ytmp(neqn),fjac(neqn*neqn)
       integer neqn,i,j,k,irec
			 external f
			 integer ier,ijac(*),iwork(*),idid
			 logical is_fjac,dojac
       do i=1,neqn
			 fnc(i)=0.d0
			 end do
			 err=1.d0
c recompute Jacobian if iter>irec
			 irec=5 
			
			 do k=1,50
			 dojac=(is_fjac.and.k.eq.1).or.k.gt.irec
			 call f(neqn,t,y1,fnc,fjac,dojac)
		   do i=1,neqn
			 ytmp(i)=y1(i)-y0(i)-h*fnc(i)
			 end do
			 if (dojac) then
			 do i=1,neqn
			 do j=1,neqn
			 fjac(i+(j-1)*neqn)=-h*fjac(i+(j-1)*neqn)
			 end do
			 fjac(1+(i-1)*(neqn+1))=fjac(1+(i-1)*(neqn+1))+1.d0
			 end do
			 CALL DEC (neqn, neqn, fjac, ijac, IER)
			 if (IER.NE.0) then
			 write (6,*) 'WARNING; BUG IN DEC TRIANGULATION'
			 pause
			 end if
			 end if
       CALL SOL (neqn, neqn, fjac, ytmp, ijac)
			 err2=err
			 err=0.d0
			 do i=1,neqn
			 y1(i)=y1(i)-ytmp(i)
			 err=err+dabs(ytmp(i))
			 end do
			 if (iwork(2).eq.0.and.err.le.tol) goto 17	
			 if (err.eq.0.d0.or.(err.le.tol.and.err.ge.err2.and.k.ge.3)) 
     &    goto 17
			 end do
			 idid=-3
			 write (6,*) 'WARNING; NEWTON ITERATION FAILED TO CONVERGE'
		   return
   17  continue
       iwork(7)=max(k,iwork(7))
			end


         