\typeout{LaTeX2e Document Style BIT Version 2002-11-01}

%Modified as suggested by John Butcher 2002 11 01
%Modified for LaTeX 2eOve Edlund 1996-05-21
%First version by Axel Ruhe 1995-01-15
% This is a LaTeX2e document class.
% Kluwer publisher entered 2003-06-26

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{bit2e}

% All options are passed to the article class.

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[leqno]{article}
%\LoadClass[leqno,11pt]{article}

%modify page sizes and indentation

%BIT page size
\textwidth 12.2cm
\textheight 19.3cm
\headsep 7mm
\topmargin 9mm
\parindent 9pt

\def\eqalign#1{\null\,\vcenter{\openup\jot\m@th
  \ialign{\strut\hfil$\displaystyle{##}$&$\displaystyle{{}##}$\hfil
      \crcr#1\crcr}}\,}
%\catcode`@=12 % at signs are no longer letters
%\catcode`@=11 % at signs are no longer letters


\def\eqalignno#1{\displ@y \tabskip=\skip11
  \halign to\displaywidth{\hfil$\@lign\displaystyle{##}$\tabskip\z@skip
    &$\@lign\displaystyle{{}##}$\hfil\tabskip=\skip11
    &\llap{$\@lign##$}\tabskip\z@skip\crcr
    #1\crcr}}

% Publishers heading
\def\bitinfo{\vbox{\hbox to \textwidth{BIT Numerical Mathematics
\hfill 0006-3835/03/4301-0001 \$16.00}
\hbox to \textwidth{2003, Vol. 43, No. 1, pp.~001--018\hfill 
\copyright~Kluwer Academic Publishers}}}


\newenvironment{AMS}{\small\textit{AMS subject classification (2000):}}{}
\newenvironment{keywords}{\small\textit{Key words:}}{}

% similar to SIAM style
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\@begintheorem#1#2{\par\bgroup{\scshape #1\ #2. }\itshape\ignorespaces}
\def\@opargbegintheorem#1#2#3{\par\bgroup{\scshape #1\ #2\ (#3).
}\itshape\ignorespaces}
\def\@endtheorem{\egroup}

\def\proof{\par{\scshape Proof}. \ignorespaces}
\def\proof{\par{\scshape Proof}. \ignorespaces}
\def\endproof{{\hfill \vbox{\hrule\hbox{%
   \vrule height1.3ex\hskip1.0ex\vrule}\hrule
  }}\par}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newtheorem{theorem}{\scshape Theorem}[section]
\newtheorem{lemma}[theorem]{\scshape Lemma}
\newtheorem{corollary}[theorem]{\scshape Corollary}
\newtheorem{proposition}[theorem]{\scshape Proposition}
\newtheorem{conjecture}[theorem]{\scshape Conjecture}
\newtheorem{definition}{\scshape Definition}[section]
\newtheorem{assumption}{\scshape Assumption}[section]
\newtheorem{algorithm}{\scshape Algorithm}[section]

\newtheorem{remark}{\scshape  Remark}[section]
\newtheorem{problem}{\scshape Problem}[section]
\newtheorem{example}{\scshape Example}[section]

%\renewcommand{\textfraction}{ 0.1}


\@afterindenttrue
%modify section headers
\renewcommand{\section}{\@startsection{section}{1}{\z@}%
                                     {3.0ex \@plus 1 ex \@minus .2ex}%
                                     {1.3ex \@plus .2 ex}%
                                     {\reset@font\normalsize\bfseries}}

%modify section headers
\renewcommand{\subsection}{\@startsection{subsection}{1}{\z@}%
                                     {2.5ex \@plus 1 ex \@minus .2ex}%
                                     {1.3ex \@plus .2 ex}%
                                     {\reset@font\normalsize\itshape}}

\renewcommand{\subsubsection}{\@startsection{subsubsection}{1}{\z@}%
                                     {2.5ex \@plus 1 ex \@minus .2ex}%
                                     {1.3ex \@plus .2 ex}%
                                     {\reset@font\normalsize\itshape}}


\def\p@enumiii{\theenumi\theenumii}
\def\p@enumiv{\p@enumiii\theenumiii}


\def\@pnumwidth{1.55em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{3}

\def\thebibliography#1{\section*{\hfil{\mdseries REFERENCES}\hfil}\list
 {\arabic{enumi}.}{\settowidth\labelwidth{[#1]}\leftmargin\labelwidth
%\advance\leftmargin\labelsep
 \usecounter{enumi}}
\itemsep=0pt
 \def\newblock{\hskip .11em plus .33em minus -.07em}
 \sloppy
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist

\long\def\@makefntext#1{\parindent 1em\noindent
 \hbox to 1.8em{\hss$^{\@thefnmark}$}#1}

\renewcommand{\bottomfraction}{.5}
\renewcommand{\floatpagefraction}{.8}

\long\def\@makecaption#1#2{\small
 \vskip 10pt
 \setbox\@tempboxa\hbox{#1: #2}
 \ifdim \wd\@tempboxa >\hsize \unhbox\@tempboxa\par \else \hbox
to\hsize{\hfil\box\@tempboxa\hfil}
 \fi}

\def\maketitle{\par
 \begingroup
 \def\thefootnote{\fnsymbol{footnote}}
 \def\@makefnmark{\hbox
 to 0pt{$^{\@thefnmark}$\hss}}
 \newpage
 \global\@topnum\z@ \@maketitle \thispagestyle{bitfirst}\@thanks
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax}
\def\@maketitle{\newpage
 \null
% \vskip 2em 
\begin{center}
 {\large \@title \par} \vskip 1.5em {\large \lineskip .5em
\begin{tabular}[t]{c}\@author
 \end{tabular}\par}
 \vskip 1em {\large \@date} \end{center}
 \par
% \vskip 1.5em
}
\def\abstract{
\section*{Abstract.}
\small
}
\def\endabstract{\normalsize}
%
\mark{{}{}}

\def\ps@myheadings{
\def\@oddhead{\hbox{}\hfil{\scriptsize \rightmark} \hfil \rmfamily\thepage}
\def\@oddfoot{}
\def\@evenhead{\rmfamily \thepage\hfil{\scriptsize\leftmark}\hfil\hbox {}}
\def\@evenfoot{}\def\sectionmark##1{}\def\subsectionmark##1{}}
%Special layout of first page
\def\ps@bitfirst{
\def\@oddhead{\scriptsize\bitinfo\hfil}
\def\@evenhead{\scriptsize\bitinfo\hfil}}
%\def\@oddfoot{\footnotesize\dates\hfil}}

\ps@myheadings\pagenumbering{arabic} \onecolumn
\@twosidetrue

\@addtoreset{equation}{section}   % Makes \section reset 'equation' counter.
\def\theequation{\thesection.\arabic{equation}}

\@addtoreset{theorem}{section}
\def\thetheorem{\thesection.\@arabic\c@theorem}
\def\thelemma{\thesection.\@arabic\c@theorem}
\def\thecorollary{\thecorollary.\@arabic\c@theorem}
\def\theproposition{\theproposition.\@arabic\c@theorem}

\@addtoreset{figure}{section}
\def\thefigure{\thesection.\@arabic\c@figure}

\@addtoreset{table}{section}
\def\thetable{\thesection.\@arabic\c@table}

%Modification suggested by John Butcher 20021101 eliminating the
%need for eqnarray.sty. He claims that the value of 0.5 for \sidestretch 
%seems to make the spacing come out right for most formats.

\def\sidestretch{0.5}
\def\eqnarray{\stepcounter{equation}\let\@currentlabel\theequation
\global\@eqnswtrue\m@th
\global\@eqcnt\z@\tabskip\@centering\let\\\@eqncr
$$\halign to\displaywidth\bgroup\@eqnsel\hskip\@centering
  $\displaystyle\tabskip\z@{##}$&\global\@eqcnt\@ne
  \hskip \sidestretch\arraycolsep \hfil${##}$\hfil
  &\global\@eqcnt\tw@ \hskip \sidestretch\arraycolsep
    $\displaystyle\tabskip\z@{##}$\hfil
   \tabskip\@centering&\llap{##}\tabskip\z@\cr}

\def\endeqnarray{\@@eqncr\egroup
      \global\advance\c@equation\m@ne$$\global\@ignoretrue}

\let\@eqnsel=\relax

\def\nonumber{\global\@eqnswfalse}

\def\@eqncr{{\ifnum0=`}\fi\@ifstar{\global\@eqpen\@M
    \@yeqncr}{\global\@eqpen\interdisplaylinepenalty \@yeqncr}}

\def\@yeqncr{\@ifnextchar [{\@xeqncr}{\@xeqncr[\z@]}}

\def\@xeqncr[#1]{\ifnum0=`{\fi}\@@eqncr
   \noalign{\penalty\@eqpen\vskip\jot\vskip #1\relax}}

\def\@@eqncr{\let\@tempa\relax
    \ifcase\@eqcnt \def\@tempa{& & &}\or \def\@tempa{& &}%
      \else \def\@tempa{&}\fi
     \@tempa \if@eqnsw\@eqnnum\stepcounter{equation}\fi
     \global\@eqnswtrue\global\@eqcnt\z@\cr}


